using UnityEngine;
using System.Collections;

public class UIShowHide : MonoBehaviour {
	
	public EasingMode easingMode;
	public float showSpeed = 4, hideSpeed = 2;
	public Vector3 showLocalPosition, hideLocalPosition, currentLocalPosition;
	[HideInInspector] public Color currentColor = Color.white;
	public float hideTarget = 0, hideT = 0;
	
	public void Show() {
		hideTarget = 0;
		gameObject.SendMessage("OnShow", SendMessageOptions.DontRequireReceiver);
	}
	
	public void Hide() {
		hideTarget = 1;
		gameObject.SendMessage("OnHide", SendMessageOptions.DontRequireReceiver);
	}
	
	void LateUpdate() {
		if (hideT == hideTarget) return;
		
		hideT = Ease.LerpValue(hideT, hideTarget, 0, 1, hideSpeed, showSpeed);
		
		if (hideT == hideTarget) {	
			if (hideTarget == 1) gameObject.SendMessage("OnHideComplete", SendMessageOptions.DontRequireReceiver);
			if (hideTarget == 0) gameObject.SendMessage("OnShowComplete", SendMessageOptions.DontRequireReceiver);
		}
		
		currentLocalPosition = Ease.V3(showLocalPosition, hideLocalPosition, hideT, easingMode);
		currentColor = new Color(1, 1, 1, Ease.Float(1 - hideT, easingMode));
	}
}
