using UnityEngine;
using System.Collections;

public class UISceneButton : MonoBehaviour {
	
	[System.Serializable]
	public class ButtonSize {
		public int size;
		public Vector3 scale;
		public Vector3 colliderCenter;
	}
	
	public Main main;
	public Transform[] backgrounds;
	public ButtonSize[] buttonSizes;
	
	[HideInInspector] public bool isUsed = false;
	
	public void SetSize(int size) {
		BoxCollider col = gameObject.GetComponent<BoxCollider>() as BoxCollider;
		Vector3 scale = GetButtonSize(size).scale;
		col.size = new Vector3(scale.x, scale.y, 0);
		col.center = GetButtonSize(size).colliderCenter;
		
		foreach (Transform bg in backgrounds) bg.transform.localScale = scale;
	}
	
	void OnPress() {
		isUsed = !isUsed;
	}
	
	void OnEnable () {
		isUsed = false;
	}
	
	private ButtonSize GetButtonSize(int size) {
		foreach (ButtonSize buttonSize in buttonSizes) if (buttonSize.size == size) return buttonSize;
		return null;
	}
	
}
