using UnityEngine;
using System.Collections;

public class UILayerColorButton : UIBase {

	public Main.LayerName layerName;
	
	void OnClick() {
		if (ui.main.infoState == Main.InfoState.Disabled) return;
		
		ui.main.SetInfoState(Main.InfoState.LayerInfo);
		ui.info.layerInfo.SetActiveLayer(layerName);
	}
	
	public void Expand() {
		collapseTarget = 0;
	}
	
	public void Collapse() {
		collapseTarget = 1;
	}
	
	#region Tweens
	
	void Awake() {
		defaultScaleY = transform.localScale.y;
	}
	
	public EasingMode easingMode;
	
	private float hiddenX = 10, collapseTarget = 1, collapseT = 1, defaultScaleY = 86;
	
	void Update() {
		if (collapseT == collapseTarget) return;
		
		collapseT = Ease.LerpValue(collapseT, collapseTarget, 0, 1, 10, 10);
		
		transform.localScale = Ease.V3(new Vector3(20, defaultScaleY, 1), new Vector3(hiddenX * collapseT, defaultScaleY, 1), collapseT, easingMode);
	}
	
	#endregion
}
