using UnityEngine;
using System.Collections;

public class UIInfo : UIBase {

	#region Public methods
	
	public UILayers layers;
	public UILayerInfo layerInfo;
	public UISoundFX soundFX;
	
	public void Show() {
		panel.widgetsAreStatic = false;
		if (hideTarget != 0) soundFX.Play();
		hideTarget = 0;
		
		switch(ui.main.infoState) {
		case Main.InfoState.LayerInfo:
			layers.SetLayerColors(true);
			
			layerInfo.Show();
			break;
		case Main.InfoState.Layers:
			layers.Show();
			
			layerInfo.Hide();
			break;
		}
	}
	
	public void Hide() {
		if (hideTarget != 1) soundFX.Play(soundFX.volume, 0.75f);
		hideTarget = 1;
	}
	
	#endregion Public methods
	
	#region Tweens
	
	public UIPanel panel;
	public Transform scalingBackground;
	
	public EasingMode easingMode;
	public float showSpeed = 4, hideSpeed = 2;
	public bool horizontal = false;
	public float hiddenY = 800, hiddenX = -700;
	
	private float hideTarget = 1, hideT = 1;
	
	void Start() {
		panel.widgetsAreStatic = true;
	}
	
	void Update() {
		if (hideT == hideTarget) return;
		
		hideT = Ease.LerpValue(hideT, hideTarget, 0, 1, showSpeed, hideSpeed);
		
		if (hideT == hideTarget) {	
			if (hideTarget == 1) {
				layers.Hide();
				layerInfo.Hide();
				panel.widgetsAreStatic = true;
			}
		}
		
		if (!horizontal) transform.localPosition = Ease.V3(Vector3.zero, new Vector3(0, hiddenY * hideT, 0), hideT, easingMode);
		else transform.localPosition = Ease.V3(Vector3.zero, new Vector3(hiddenX * hideT, 0, 0), hideT, easingMode);
		
		if (scalingBackground != null) {
			float bgScaleOffset = 1500 * hideT;
			scalingBackground.transform.localScale = new Vector3(414, 2000 - bgScaleOffset, 1);
		}
	}
	
	#endregion
}
