using UnityEngine;
using System.Collections;

[ExecuteInEditMode]
public class UIAboutButton : MonoBehaviour {

	public UILanguageSelection languageSelection;
	public UILanguageSelection.Mode gotoMode;
	
	void Awake() {
		UpdateTransform();
	}
	
	void Update() {
		if (!Application.isPlaying) UpdateTransform();
	}
	
	void OnClick() {
		languageSelection.SetMode(gotoMode);
	}
	
	private void UpdateTransform() {
		 transform.localPosition = new Vector3(- 100, -100, -11);
	}
}
