using UnityEngine;
using UnityEditor;
using System.Collections;

public class EditorHelper : EditorWindow {
	
    [MenuItem ("GeoApp/EditorHelper")]
    static void Init () {
		EditorWindow.GetWindow(typeof(EditorHelper));
    }
	
    void OnGUI () {
		EditorGUILayout.Space();
		
		AssignAudioClips();
		SetLanguage();
		
		EditorGUILayout.Space();
    }
	
	#region AssignAudioClips
	
	private AudioClip clipButton, clipSceneButton, clipSwipe;
	private float volumeButton = 1;
	private float volumeSceneButton = 1;
	private float volumeSwipe = 1;
	
	private void AssignAudioClips() {
		EditorGUILayout.BeginVertical("Box");		
		clipButton = (AudioClip)EditorGUILayout.ObjectField("Button", clipButton, typeof(AudioClip), false);
		clipSceneButton = (AudioClip)EditorGUILayout.ObjectField("SceneButton", clipSceneButton, typeof(AudioClip), false);
		clipSwipe = (AudioClip)EditorGUILayout.ObjectField("Swipe", clipSwipe, typeof(AudioClip), false);
		
		volumeButton = EditorGUILayout.FloatField("Button Volume", volumeButton);
		volumeSceneButton = EditorGUILayout.FloatField("SceneButton Volume", volumeSceneButton);
		volumeSwipe = EditorGUILayout.FloatField("Swipe Volume", volumeSwipe);
		
		if (GUILayout.Button("Assign AudioClips")) {
			UISoundFX[] sounds = (UISoundFX[])GameObject.FindObjectsOfType(typeof(UISoundFX));
			
			foreach (UISoundFX s in sounds) {
				switch(s.audioName) {
				case "Button": 
					s.audioClip = clipButton;
					s.volume = volumeButton;
					break;
				case "Swipe":
					s.audioClip = clipSwipe;
					s.volume = volumeSwipe;
					break;
				case "SceneButton":
					s.audioClip = clipSceneButton;
					s.volume = volumeSceneButton;
					break;
				}
			}
		}
		EditorGUILayout.EndVertical();
	}
	
	#endregion
	
	#region SetLanguage
	
	private Translator.Language language;
	
	private void SetLanguage() {
		
		EditorGUILayout.Space();
		EditorGUILayout.BeginVertical("Box");
		
		language = (Translator.Language)EditorGUILayout.EnumPopup("Language", language);
		
		if (GUILayout.Button("SetLanguage")) {
			Main main = (Main)GameObject.FindObjectOfType(typeof(Main));
			main.SetLanguage(language);
			
		}
		EditorGUILayout.EndVertical();
	}
	
	#endregion
	
}