using UnityEngine;
using UnityEditor;
using System.Collections;

public class Deployment : EditorWindow {
	
    [MenuItem ("GeoApp/Deployment")]
    static void Init () {
		EditorWindow.GetWindow(typeof(Deployment));
		Main main = (Main)GameObject.FindObjectOfType(typeof(Main));
		_deviceName = main.deviceName;
    }
	
	private static Main.DeviceName _deviceName;
	
	void OnGUI () {
		EditorGUILayout.Space();
		
		_deviceName = (Main.DeviceName)EditorGUILayout.EnumPopup("Device", _deviceName);
		
		if (GUILayout.Button("Switch")) {
			SwitchDeployment(_deviceName, false);
		}
    }
	
	public static void SwitchDeployment(Main.DeviceName deviceName, bool destroyOthers) {
		Main main = (Main)GameObject.FindObjectOfType(typeof(Main));
			
		main.deviceName = deviceName;
			
		UIInterface activateUI = null;
		foreach (Main.DeviceReferences d in main.deviceReferences) {
			if (d.deviceName == deviceName && d.uiInterface != null) {
				activateUI = d.uiInterface;
				activateUI.Activate();
				PlayerSettings.defaultScreenWidth = (int)d.defaultResolution.x;
				PlayerSettings.defaultScreenHeight = (int)d.defaultResolution.y;
					
				if (d.deviceName == Main.DeviceName.Web) {
					PlayerSettings.defaultWebScreenWidth = (int)d.defaultResolution.x;
					PlayerSettings.defaultWebScreenHeight = (int)d.defaultResolution.y;
				}
			}
		}
			
		foreach (Main.DeviceReferences d in main.deviceReferences) {
			if (d.uiInterface != null && d.uiInterface != activateUI) {
				if (destroyOthers) DestroyImmediate(d.uiInterface.gameObject);
				else d.uiInterface.Deactivate();
			}			
		}
	}
}