using UnityEngine;
using System.Collections;
using System;

public class Drill : MonoBehaviour {

	public LayerMask layerMask;
	
	private RaycastHit[] hits;
	
	[System.Serializable]
	public class Layer {
		public string name;
		public float z;
		public float thickness;
	}
	
	[System.Serializable]
	public class Profile {
		public Layer[] layers;
	}
	
	public static string[] layerOrder = new string[8]{"Water", "QP", "Devon", "Silur", "Ordoviitsium", "Kambrium", "Ediacara", "Aluskord"};
	
	public Profile GetProfile(Vector2 coords) {		
		hits = Physics.RaycastAll(new Vector3(coords.x, 10, coords.y), Vector3.down, 100, layerMask);
		
		Profile profile = new Profile();
		profile.layers = new Layer[0];
		
		foreach (string layerName in layerOrder) {
			foreach (RaycastHit hit in hits) {
				if (hit.collider.gameObject.tag == layerName) {
					Layer layer = new Layer();
					layer.name = layerName;
					layer.z = Mathf.Round(CoordinateConverter.ConvertZToLEst(hit.distance - 10));
					//if (layer.name == "Water" && Math.Abs(layer.z) < 0.1f) layer.z = 0;
					
					Array.Resize(ref profile.layers, profile.layers.Length + 1);
					profile.layers[profile.layers.Length - 1] = layer;
				}
			}
		}
		
		if (profile.layers.Length == 0) return profile;
		
		for (int i = 0; i < profile.layers.Length - 1; i++) {
			profile.layers[i].thickness = profile.layers[i + 1].z - profile.layers[i].z;
		}
		profile.layers[profile.layers.Length - 1].thickness = 1000 - profile.layers[profile.layers.Length - 1].z;
		
		foreach (Layer layer in profile.layers) {
			layer.z = -layer.z;
		}
		
		return profile;
	}
}
