using UnityEngine;
using System.Collections;

public abstract class CameraBase : MonoBehaviour {
	
	public Main main;
	
	public float fieldOfView = 45, clipNear = 10;
	[HideInInspector] public bool inputEnabled = true;
	
	public abstract Vector3 GetPosition();
	public abstract Quaternion GetRotation();
	public abstract bool GetMoving();
	public abstract void Reset();
	
	public float pinchDistance = 0;
	
	public void StartZoom() {
		if (Input.touchCount < 2) return;
		pinchDistance = Vector2.Distance(Input.touches[0].position, Input.touches[1].position);
	}
	
	public Main.InputMode inputMode {
		get {
			if (Application.isEditor) return Main.InputMode.MouseKeyboard;
			if (!Input.multiTouchEnabled) return Main.InputMode.MouseKeyboard;
			return main.references.inputMode;
		}
	}
	
	public float zoomAdd {
		get  {
			switch(inputMode) {
			case Main.InputMode.MouseKeyboard: 
				float scroll = Input.GetAxis("Mouse ScrollWheel");
				if (scroll < 0) return 1;
				if (scroll > 0) return -1;
				return Input.GetAxis("Mouse Y");
			default:
				if (Input.touchCount < 2) return 0;
				float d = Vector2.Distance(Input.touches[0].position, Input.touches[1].position);
				float r = pinchDistance - d;
				pinchDistance = d;
				return r * Time.deltaTime * 0.7f * screenSizeF;
			}
		}
	}
	
	private float screenSizeF {
		get {
			return 300 / (float)Screen.height;
		}
	}
	
	public Vector3 panAdd {
		get {
			switch(inputMode) {
			case Main.InputMode.MouseKeyboard: return new Vector3(-Input.GetAxis("Mouse X"), -Input.GetAxis("Mouse Y"), 0);
			default: return -Input.touches[0].deltaPosition * Time.deltaTime * 5 * screenSizeF;
			}
		}
	}
	
	public Vector3 zoomPanAdd {
		get {
			switch(inputMode) {
			case Main.InputMode.MouseKeyboard: return panAdd;
			default: 
				if (Input.touchCount >= 2) {
					return (Input.touches[0].deltaPosition + Input.touches[1].deltaPosition) * -2.5f * Time.deltaTime * screenSizeF;
				}
				return -Input.touches[0].deltaPosition * Time.deltaTime * 5 * screenSizeF;
			}
		}
	}
	
	public Vector2 rotateAdd {
		get {
			switch(inputMode) {
			case Main.InputMode.MouseKeyboard: return new Vector2(Input.GetAxis("Mouse X"), Input.GetAxis("Mouse Y"));
			default: return Input.touches[0].deltaPosition * Time.deltaTime * 3 * screenSizeF;	
			}
		}
	}
}
