Shader "CrossSection/CrossSectionSurface" {
    Properties {
      section_depth ("section depth", float) = 5
    
      _MainTex ("Texture", 2D) = "white" {}
      _MainColor ("Main Color", Color) = (1, 1, 1, 1)
      _SectionColor("Section Color", Color) = (0.3, 0.3, 0.3, 1)
    }
    SubShader {    
      Tags { "RenderType" = "Opaque" }

      Cull Front
 	  CGPROGRAM
      #pragma surface surf None vertex:vert
      
      half4 LightingNone (SurfaceOutput s, half3 lightDir, half atten) {
          return half4(s.Albedo, 1);
      }
      
      struct Input {
          float4 mask;
      };
      
      uniform float section_depth;
	  uniform float4x4 _Rotation;
      float4 _SectionColor;

      void vert (inout appdata_full v, out Input o) {
        float4 c = float4(v.vertex.xyz, 1.0);
        o.mask = mul(_Rotation, c);
      }
     
      void surf (Input IN, inout SurfaceOutput o) {
       	 if (IN.mask.x > section_depth) clip(-1.0);
       	 o.Albedo = 0.0;
         o.Emission = _SectionColor.rgb;
      }
      
      ENDCG  

      Cull Back
      CGPROGRAM
      #pragma surface surf Lambert vertex:vert
      
      struct Input {
          float2 uv_MainTex;
          float4 mask;
      };
      
	  uniform float section_depth;
	  uniform float4x4 _Rotation;
      sampler2D _MainTex;
      float4 _MainColor;
    
      void vert (inout appdata_full v, out Input o) {
       	float4 c = float4(v.vertex.xyz, 1.0);
      	o.mask = mul(_Rotation, c);
      }
      
      void surf (Input IN, inout SurfaceOutput o) {
          if (IN.mask.x > section_depth) clip(-1.0);
		  o.Albedo = tex2D (_MainTex, IN.uv_MainTex).rgb * _MainColor.rgb;
      }     

      ENDCG
    } 
    Fallback "VertexLit"
  }