Shader "CrossSection/CrossSectionDisabledDouble" {
     Properties {
        _Color ("Main Color", Color) = (1,1,1,0.5)
        _MainTex ("Base (RGB)", 2D) = "white" { }
        _SectionColor("Section Color", Color) = (0.3, 0.3, 0.3, 1)
    }

    SubShader {
    	Pass {
        	Lighting Off
        	Cull Front

            Material {
                Emission [_SectionColor]
            }
            Lighting On
        }
        
        Pass {
        	Lighting On
        	Cull Back
        
            Material {
                Diffuse [_Color]
                Ambient [_Color]
            }

            SetTexture [_MainTex] {
                constantColor [_Color]
                Combine texture * primary DOUBLE, texture * constant
            }
        }
    }
}

