Shader "CrossSection/CrossSectionBumpedSpecularDisabledDouble" {
    Properties {
      _MainTex ("Texture", 2D) = "white" {}
      _BumpMap ("Bumpmap", 2D) = "bump" {}
      _MainColor ("Main Color", Color) = (1, 1, 1, 1)
      _SectionColor("Section Color", Color) = (0.3, 0.3, 0.3, 1)
    }
    
    SubShader { 
      Tags { "RenderType" = "Opaque" }
     
      Cull Front
 	  CGPROGRAM
      #pragma surface surf None
      
      half4 LightingNone (SurfaceOutput s, half3 lightDir, half atten) {
          return half4(s.Albedo, 1);
      }
      
      struct Input {
        float2 uv_MainTex;
      };
      
      float4 _SectionColor;
      
      void surf (Input IN, inout SurfaceOutput o) {
		o.Albedo = 0;
		o.Emission = _SectionColor.rgb;
      }
      ENDCG
     
      Cull Back
       CGPROGRAM
      #pragma surface surf BlinnPhong
      
      struct Input {
        float2 uv_MainTex;
        float2 uv_BumpMap;
      };
      
      sampler2D _MainTex;
      sampler2D _BumpMap;
      float4 _MainColor;
      
      void surf (Input IN, inout SurfaceOutput o) {
        o.Normal = UnpackNormal (tex2D (_BumpMap, IN.uv_BumpMap));
		o.Albedo = tex2D(_MainTex, IN.uv_MainTex) * _MainColor.rgb;
      }
      ENDCG
    } 
    Fallback "Specular"
  }