using UnityEngine;
using System.Collections;

public class RasterData: MonoBehaviour {

	public Texture2D texture;
	public Rect extents;
	public bool flipY;
	
	public Color GetPixel(Vector2 coords) {
		Vector2 uv = GetUV(coords);
		if (uv.x <= 0 || uv.x >= 1 || uv.y <= 0 || uv.y >= 1) return Color.clear;
		return texture.GetPixelBilinear(uv.x, uv.y);
	}
	
	public Vector2 GetUV(Vector2 coords) {
		Vector2 relativeCoords = new Vector2(coords.x - extents.x, coords.y - extents.y);
		Vector2 uv = new Vector2(relativeCoords.y / extents.height, relativeCoords.x / extents.width);
		if (flipY) uv.y = 1 - uv.y;
		return uv;
	}
	
	public Vector2 GetCoords(Vector2 uv) {
		if (flipY) uv.y = 1 - uv.y;
		return new Vector2(extents.x + (uv.y * extents.width), extents.y + (uv.x * extents.height));
	}
}
