using UnityEditor;
using UnityEngine;
using System.Collections;
using System.IO;
using System.Text;

public class UVMapping: EditorWindow {
	
	private GameObject mappingObject;
	private string mappingObjectName = "";
	private RasterData rasterData;
	
	[MenuItem ("GeoApp/UVMapping")]
    static void Init () {
		EditorWindow.GetWindow(typeof(UVMapping));
    }
	
	void OnGUI() {
		mappingObject = (GameObject)EditorGUILayout.ObjectField("UV Map Object", mappingObject, typeof(GameObject), true);
		rasterData = (RasterData)EditorGUILayout.ObjectField("Raster Data", rasterData, typeof(RasterData), true);
		mappingObjectName = EditorGUILayout.TextField("Name", mappingObjectName);
		
		if (GUILayout.Button("Apply UV Mapping") && mappingObject != null && mappingObjectName != "") {
			ApplyUV(mappingObject, rasterData, mappingObjectName);
		}
	}
	
	private void ApplyUV(GameObject gameObject, RasterData rasterData, string name) {
		MeshFilter filter = gameObject.GetComponent<MeshFilter>();
		filter.sharedMesh.uv = UVPlanarXZ(rasterData, filter.sharedMesh.vertices);
		
		string assetPath = Application.dataPath + "/Resources/GeoMesh/" + name + ".obj";
		
		using (StreamWriter sw = new StreamWriter(assetPath)) {
			sw.Write(ObjExporter.MeshToString(filter));
		}
		
		AssetDatabase.Refresh();
		
		ModelImporter modelImporter = AssetImporter.GetAtPath(assetPath) as ModelImporter;
	
		if (modelImporter != null) {
			modelImporter.normalImportMode = ModelImporterTangentSpaceMode.Calculate;
			modelImporter.tangentImportMode = ModelImporterTangentSpaceMode.Calculate;
						
			AssetDatabase.ImportAsset(assetPath, ImportAssetOptions.ForceUpdate);
		}
	}
	
	public static Vector2[] UVPlanarXZ(RasterData rasterData, Vector3[] vertices) {
		Vector2[] newUvs = new Vector2[vertices.Length];
		for (int i = 0; i < vertices.Length; i++) {
			Vector2 coordsLEst = CoordinateConverter.ConvertXYToLEst(new Vector2(vertices[i].x, vertices[i].z));
			newUvs[i] = rasterData.GetUV(coordsLEst);
		}
		return newUvs;
	}
}

