using UnityEngine;
using System.Collections;

public class CoordinateConverter : MonoBehaviour {

	public static Vector2 offsetXY = new Vector3(-73, -1345); // new Vector3(-73, -1325);
	public static float scale = 0.0002f;
	public static float zMultiplier = 25;
	
	public static Vector2 ConvertXY(Vector2 input) {
		return (new Vector2(input.y, input.x) * scale) + offsetXY;
	}
	
	public static float ConvertZ(float input) {
		return input * scale * zMultiplier;
	}
	
	public static Vector2 ConvertXYToLEst(Vector2 input) {
		Vector2 v = (input - offsetXY) / scale;
		return new Vector2(v.y, v.x);
	}
	
	public static float ConvertZToLEst(float input) {
		return input / scale / zMultiplier;
	}
}
