using UnityEngine;
using System.Collections;

[ExecuteInEditMode]
public class UISplashLogo : UIAutoScaleBase {
	
	public UISlicedSprite sprite;
	public float scaleF = 0.001f;
	public Vector2 defaultPosition;
	public float maxXOffset = 675;
	public float minScale = 1;
	public float maxScale = 2;
	public bool updateColor;
	
	public override void OnUpdateScale() {
		if (defaultScale.x <= 0 || defaultScale.y <= 0) return;
		if (defaultScreen.x <= 0 || defaultScreen.y <= 0) return;
		
		transform.localPosition = currentLocalPosition + new Vector3(Mathf.Clamp(defaultPosition.x * currentScaleF * widthAspectMlp, -maxXOffset * widthAspectMlp, maxXOffset * widthAspectMlp), defaultPosition.y * widthAspectMlp, transform.localPosition.z);
		transform.localScale = new Vector3(defaultScale.x * scaleMlp, defaultScale.y * scaleMlp, 1);
	}
	
	public override void OnUpdate() {
		if (updateColor) sprite.color = currentColor;
	}
	
	private float scaleMlp {
		get {
			return Mathf.Clamp(1 - (screenHeightOffset * scaleF), minScale, maxScale);
		}
	}
}
