using UnityEngine;
using System.Collections;

public class UISplashInstructions : UIAutoScaleBase {
	
	public UISlicedSprite sprite;
	public float scaleF = 0.001f;
	public float minScale = 1;
	public float maxScale = 2;
	public AnimationCurve alphaCurve;
	public float alphaSpeed = 1;
	public float alphaTimer = 0;
	public bool updateTransform, updateColor, updateBlink;
	
	public override void OnUpdateScale() {
		transform.localScale = new Vector3(defaultScale.x * scaleMlp, defaultScale.y * scaleMlp, 1);
	}
	
	private float scaleMlp {
		get {
			return Mathf.Clamp(1 - (screenHeightOffset * scaleF), minScale, maxScale);
		}
	}
	
	public void OnHide() {
		updateBlink = false;
	}
	
	public override void OnUpdate() {
		Color c = Color.white;
		
		if (updateBlink) {
			alphaTimer += Time.deltaTime * alphaSpeed;
			if (alphaTimer > 1) alphaTimer -= 1;
			c.a *= alphaCurve.Evaluate(alphaTimer);
		}
		
		if (updateColor) {
			c.r *= currentColor.r;
			c.g *= currentColor.g;
			c.b *= currentColor.b;
			c.a *= currentColor.a;
		}
		
		if (updateBlink || updateColor) sprite.color = c;		
		if (updateTransform) transform.localPosition = currentLocalPosition;
	}
}
