using UnityEngine;
using System.Collections;

public class UISceneButtonCam : UISceneButton {
	
	public CameraController cameraController;
	public CrossSection crossSection;
	public UIButton button;
	public GameObject bgCam, bgBack;
	public GameObject[] hideObjects;
	public UIScaler scaler;
	
	public int mode = 0;
	
	void Start() {
		cameraController.modeSet += OnModeSet;
	}
	
	public void OnModeSet(int _mode) {
		if (main.toolState != Main.ToolState.Scissors) return;
		
		if (_mode == 0) {
			foreach (GameObject hideObject in hideObjects) NGUITools.SetActive(hideObject, true);
			NGUITools.SetActive(bgCam, true);
			button.tweenTarget = bgCam;
		} else {
			NGUITools.SetActive(bgBack, true);
			button.tweenTarget = bgBack;
			crossSection.Activate();
			scaler.Show();
		}
	}
	
	public void SetMode(int _mode, bool hideButtons) {
		if (hideButtons) {
			NGUITools.SetActive(bgCam, false);
			NGUITools.SetActive(bgBack, false);
		} else {
			NGUITools.SetActive(bgCam, true);
			button.tweenTarget = bgCam;
			NGUITools.SetActive(bgBack, false);
		}
		
		mode = _mode;
		
		if (mode == 1) {
			foreach (GameObject hideObject in hideObjects) NGUITools.SetActive(hideObject, false);
		} else {
			if (hideButtons) crossSection.Deactivate();
			scaler.Hide();
		}
		
		cameraController.SetMode(mode);
	}
	
	void OnClick() {
		if (mode == 0) SetMode(1, true);
		else SetMode(0, true);
	}
}
