using UnityEngine;
using System.Collections;

public class UIScaler : MonoBehaviour {
	
	public Main main;
	public UIPanel panel;
	public GeoMeshManager geoMeshManager;
	public UICustomSlider slider;
	public UITexture bar;
	public UILabel label;
	public UILabel[] scales;
	
	public EasingMode easingMode;
	public float showSpeed = 4, hideSpeed = 2;
	public float showX = -50, hiddenX = 200;
	
	private float hideTarget = 1, hideT = 1;
	
	public void Hide() {
		if (hideTarget != 1 && !main.references.optimizations.geoMeshScaling) slider.LerpValue(0.5f);
		hideTarget = 1;
	}
	
	public void Show() {
		hideTarget = 0;
		panel.widgetsAreStatic = false;
	}
	
	public bool isUsed {
		get {
			return slider.isUsed;
		}
	}
	
	private int fontSize {
		get {
			if (main.references.fontSize == 0) return 18;
			return 36;				
		}
	}
	
	void Start() {
		slider.SetRange(-height, 0);
		bar.transform.localScale = new Vector3(5, height, 1);
		
		for (int i = 0; i < scales.Length; i++) {
			scales[i].transform.localPosition = new Vector3(-45, (-height / 5) * i, 0);
			scales[i].transform.localScale = new Vector3(fontSize, fontSize, 1);
		}
		
		label.transform.localScale = new Vector3(fontSize, fontSize, 1);
		
		slider.onChanged += OnValueChanged;
		slider.SetValue(0.5f);
		
		panel.widgetsAreStatic = true;
	}
	
	public void OnValueChanged() {
		float y = Mathf.Clamp(slider.value * 50, 1, 50);
		geoMeshManager.SetScale(y);
		label.text = Mathf.RoundToInt(y).ToString() + " : 1";
	}
	
	void Update() {		
		if (hideT == hideTarget) return;
		hideT = Ease.LerpValue(hideT, hideTarget, 0, 1, hideSpeed, showSpeed);
		
		if (hideT == 1 && hideTarget == 1) panel.widgetsAreStatic = true; 
		
		transform.localPosition = Ease.V3(new Vector3(showX, -75, 0), new Vector3(hiddenX * hideT, -75, 0), hideT, easingMode);
	}
	
	private float height {
		get {
			return Screen.height - (125);
		}
	}
	
	private float aspect {
		get {
			return (float)Screen.height / 640.0f;
		}
	}
}
