using UnityEngine;
using System.Collections;

public class UILayerInfo : UIBase {
	
	public UIPanel[] refreshPanels;
	
	public int labelOffset = -150, textOffset = -195;
	
	[System.Serializable]
	public class Layer {
		public Main.LayerName layerName;
		public UILayerColorButton colorButton;
	}
	
	public UISoundFX soundFX;
	public UICustomSlider slider;
	public UILabelMultilanguage label, text;
	public UISlicedSprite layerImg;
	public GameObject buttonBack, background;
	public Layer[] layers;
	public float disableScrollScreenHeight = 9999;
	public GameObject scrollButton;
	public GameObject scrollLine;
	
	private Layer activeLayer;
	
	#region Public methods
	
	public void Show() {
		if (hideTarget != 0) soundFX.Play(soundFX.volume * 0.75f, 1);
		hideTarget = 0;
		panel.widgetsAreStatic = false;
	}
	
	public void Hide() {
		if (hideTarget != 1) soundFX.Play(soundFX.volume * 0.75f, 0.75f);
		hideTarget = 1;
		activeLayer = null;
	}
	
	public void SetActiveLayer(Main.LayerName layerName) {
		activeLayer = null;
		
		foreach (Layer layer in layers) {
			if (layer.layerName == layerName) {
				label.textName = "Heading" + layer.layerName.ToString();
				text.textName = "Text" + layer.layerName.ToString();
				layerImg.spriteName = "LayerImg" + layer.layerName.ToString();
				
				label.SetText(ui.main.translator, ui.main.language);
				text.SetText(ui.main.translator, ui.main.language);
				
				layer.colorButton.Expand();
				activeLayer = layer;
			} else {
				layer.colorButton.Collapse();
			}
		}
		
		if (slider != null) {
			if (activeLayer != null) {
				float languageF = 0.5f;
				if (text.currentLanguage == Translator.Language.Russian) languageF = 0.8f;
				slider.SetRange(0, Mathf.Clamp(text.uiLabel.text.Length * languageF, 100, 900));
			}
			slider.SetValue(0);
		}
		
		OnSliderChanged();
		foreach (UIPanel refreshPanel in refreshPanels) refreshPanel.Refresh();
	}
	
	#endregion Public methods
	
	#region Tweens
	
	public UIPanel panel;
	public EasingMode easingMode;
	public float showSpeed = 4, hideSpeed = 2, showX = 0, hiddenX = -600;
	
	private float hideTarget = 1, hideT = 1;
	
	void Start() {
		panel.widgetsAreStatic = true;
		
		if (Screen.height >= disableScrollScreenHeight) {
			slider.enabled = false;
			NGUITools.SetActive(scrollButton, false);
			NGUITools.SetActive(scrollLine, false);
		} else if (slider != null) slider.onChanged += OnSliderChanged;
	}

	public void OnSliderChanged() {
		if (activeLayer != null) {
			float yOffset = 0;
			if (slider != null) yOffset = slider.transform.localPosition.y;
			
			label.transform.localPosition = new Vector3(34, labelOffset + yOffset, 0);
			text.transform.localPosition = new Vector3(34, textOffset + yOffset, 0);
		}
	}

	void Update() {
		if (hideT == hideTarget) return;
		
		hideT = Ease.LerpValue(hideT, hideTarget, 0, 1, showSpeed, hideSpeed);
		
		if (hideT == hideTarget) {	
			if (hideTarget == 0) {
				ui.info.layers.SetLayerButtons(false);
			}
			
			if (hideTarget == 1) {
				foreach (Layer layer in layers) layer.colorButton.Collapse();
				panel.widgetsAreStatic = true;
			}
		}
		
		transform.localPosition = Ease.V3(new Vector3(showX, 0, -30), new Vector3(hiddenX * hideT, 0, -30), hideT, easingMode);
	}
	
	#endregion
}
