using UnityEngine;
using System.Collections;

public class UILanguageSelection : MonoBehaviour {
	
	[System.Serializable]
	public enum Mode {
		PlaeaseWait,
		LanguageSelection,
		About,
		Selected
	}
	
	public Mode mode = Mode.PlaeaseWait;
	
	public UIPanel[] panels;
	public GameObject title;
	public GameObject background;
	public GameObject[] abouts;
	public GameObject[] buttons;
	public GameObject textPleaseWait, textSelectLanguage;
	public UIShowHide[] showHides;
	
	private Translator.Language selectedLanguage;
	private bool selected = false;
	private bool destroyed = false;
	//private bool inTouch = false;
	
	void Awake() {
		DontDestroyOnLoad(gameObject);
		
		//SetMode(Mode.PlaeaseWait);
	}
	
	#region Public methods
	
	public void SetMode(Mode _mode) {
		mode = _mode;
		
		switch(mode) {
		case Mode.About:
			NGUITools.SetActive(textSelectLanguage, false);
			NGUITools.SetActive(textPleaseWait, false);
			NGUITools.SetActive(background, false);
			NGUITools.SetActive(title, false);
			foreach (GameObject button in buttons) NGUITools.SetActive(button, false);
			//inTouch = true;
			
			foreach (GameObject about in abouts) NGUITools.SetActive(about, true);
			break;
		case Mode.LanguageSelection:
			NGUITools.SetActive(textPleaseWait, false);
			foreach (GameObject about in abouts) NGUITools.SetActive(about, false);
			
			NGUITools.SetActive(background, true);
			NGUITools.SetActive(title, true);
			NGUITools.SetActive(textSelectLanguage, true);
			foreach (GameObject button in buttons) NGUITools.SetActive(button, true);
			break;
		case Mode.PlaeaseWait:
			foreach (GameObject button in buttons) NGUITools.SetActive(button, false);
			foreach (GameObject about in abouts) NGUITools.SetActive(about, false);
			NGUITools.SetActive(textSelectLanguage, false);
			
			NGUITools.SetActive(textPleaseWait, true);
			NGUITools.SetActive(background, true);
			NGUITools.SetActive(title, true);
			break;
		case Mode.Selected:
			NGUITools.SetActive(textSelectLanguage, false);
			foreach (GameObject button in buttons) NGUITools.SetActive(button, false);
			break;
		}
		
		foreach (UIPanel panel in panels) panel.Refresh();
	}
	
	public void Select(Translator.Language language) {
		if (selected) return;
		
		selectedLanguage = language;
		selected = true;
		
		SetMode(Mode.Selected);
	}
	
	#endregion
	
	void OnLevelWasLoaded(int level) {
        if (level != 0) SetMode(Mode.LanguageSelection);
	}
	
	void Update() {
		/*
		if (mode == Mode.About) {
			if (Input.anyKey) SetMode(Mode.LanguageSelection);
			else {
				if (Input.touchCount == 0) inTouch = false;
				if (!inTouch && Input.touchCount > 0) SetMode(Mode.LanguageSelection);
			}
		}
		*/
		if (!selected) return;
		if (destroyed) return;
		
		Main main = (Main)GameObject.FindObjectOfType(typeof(Main));
		if (main == null) return;
		
		main.SetLanguage(selectedLanguage);
		
		foreach (UIShowHide showHide in showHides) showHide.Hide();
		StartCoroutine(DestroyDelayed());
	}
	
	private IEnumerator DestroyDelayed() {
		yield return new WaitForSeconds(0.5f);
		NGUITools.Destroy(gameObject);
	}
}
