using UnityEngine;
using System.Collections;

public class UILabelMultilanguage : MonoBehaviour {
	
	public UILabel uiLabel {
		get {
			if (_uiLabel == null) _uiLabel = gameObject.GetComponent<UILabel>();
			return _uiLabel;
		}
	}
	private UILabel _uiLabel;
	
	public string textName, fontName;
	[HideInInspector] public Translator.Language currentLanguage;
	
	public void SetText(Translator translator, Translator.Language language) {
		currentLanguage = language;
		uiLabel.text = translator.GetTranslation(textName, language);
	}
	
	public void SetFont(UIFont font) {
		uiLabel.font = font;
	}
}
