using UnityEngine;
using System.Collections;

public class UIDrill : MonoBehaviour {

	public Transform drillPoint;
	public Collider groundCollider;
	public Camera mainCamera;
	public UISceneButtonDrill drillDot;
	public LayerMask layerMask;
	
	private bool hidden = false;
	private Ray ray;
	private RaycastHit hit;
	private Vector3 drillDotOffset = Vector3.zero;
	private bool lastUsed = false;
	
	public void SetSize(int size) {
		drillDot.SetSize(size);
	}
	
	public void Show() {
		NGUITools.SetActive(drillDot.gameObject, true);
		NGUITools.SetActive(groundCollider.gameObject, true);
		
		drillDot.Profile();
		
		hidden = false;
	}
	
	public void Hide() {
		StopAllCoroutines();
		NGUITools.SetActive(drillDot.gameObject, false);
		NGUITools.SetActive(groundCollider.gameObject, false);
		
		hidden = true;
	}
	
	public bool isUsed {
		get { 
			return drillDot.isUsed; 
		}
	}
	
	void Update() {
		if (hidden) return;
		
		if (drillDot.isUsed) {
			ray = mainCamera.ScreenPointToRay(Input.mousePosition - drillDotOffset);
			if (Physics.Raycast(ray, out hit, Mathf.Infinity, layerMask)) {
				if (!lastUsed) drillDotOffset = drillPoint.position - new Vector3(hit.point.x, drillPoint.position.y, hit.point.z);
				Vector3 p = new Vector3(hit.point.x, drillPoint.position.y, hit.point.z) + drillDotOffset;
				
				drillPoint.position = new Vector3(
					Mathf.Clamp(p.x, 0.5f, 74.5f),
					p.y,
					Mathf.Clamp(p.z, -70, -0.5f));
			}
		}
		
		lastUsed = isUsed;
		
		Vector3 screenRoot = mainCamera.WorldToScreenPoint(drillPoint.position);
		drillDot.transform.localPosition = screenRoot;
	}
}
