using UnityEngine;
using System.Collections;

public class UICrossSection : MonoBehaviour {
	
	public Main main;
	public CrossSection crossSection;
	public Camera mainCamera;
	public CameraController cameraController;
	public UISceneButton scissors, rotate;
	public UISceneButtonCam cam;
	public Transform dottedLine;
	public Collider groundCollider;
	public LayerMask layerMask;
	
	private Ray ray;
	private RaycastHit hit;
	private Vector3 crossSectionOffset = Vector3.zero;
	private Quaternion crossSectionRotationOffset = Quaternion.identity;
	private bool lastUsed, lastTransformToolsUsed, hidden;
	private int size;
	
	public bool isUsed {
		get { 
			return scissors.isUsed || rotate.isUsed || cam.isUsed; 
		}
	}
	
	private bool transformToolsUsed {
		get {
			return scissors.isUsed || rotate.isUsed;
		}
	}
	
	public void SetSize(int _size) {
		size = _size;
		scissors.SetSize(size);
		rotate.SetSize(size);
		cam.SetSize(size);
	}
	
	public void Show() {
		NGUITools.SetActive(scissors.gameObject, true);
		NGUITools.SetActive(rotate.gameObject, true);
		NGUITools.SetActive(cam.gameObject, true);
		NGUITools.SetActive(dottedLine.gameObject, true);
		NGUITools.SetActive(groundCollider.gameObject, true);

		crossSection.DisableDouble();
		
		cam.SetMode(0, false);
		hidden = false;
	}
	
	public void Hide() {
		crossSection.Disable();
		
		cam.SetMode(0, false);
		
		NGUITools.SetActive(scissors.gameObject, false);
		NGUITools.SetActive(rotate.gameObject, false);
		NGUITools.SetActive(cam.gameObject, false);
		NGUITools.SetActive(dottedLine.gameObject, false);
		NGUITools.SetActive(groundCollider.gameObject, false);
		
		hidden = true;
	}
	
	void Update() {
		if (hidden) return;
		
		if (cam.mode == 1) {
			cam.transform.localPosition = new Vector3(Screen.width * 0.5f, Screen.height - Mathf.Clamp(Screen.height * 0.2f, 50, 500), 0);
			return;
		}
		
		if (scissors.isUsed) {
			ray = mainCamera.ScreenPointToRay(Input.mousePosition);
			if (Physics.Raycast(ray, out hit, Mathf.Infinity, layerMask)) {
				Vector3 p = new Vector3(hit.point.x, crossSection.transform.position.y, hit.point.z);
				if (!lastUsed) crossSectionOffset = crossSection.transform.position - p;
				
				Vector3 v = p + crossSectionOffset;
				crossSection.transform.position = new Vector3(
					Mathf.Clamp(v.x, 0, 74.5f),
					v.y,
					Mathf.Clamp(v.z, -70, 0));
				
				
				if (main.references.optimizations.realtimeCrossSectioning) {
					if (crossSection.shaderMode != CrossSection.ShaderMode.Enabled) crossSection.Enable();
					crossSection.UpdateClippingPlane();
				}
			}
		}
		
		if (rotate.isUsed) {
			ray = mainCamera.ScreenPointToRay(Input.mousePosition);
			if (Physics.Raycast(ray, out hit, Mathf.Infinity, layerMask)) {
				Quaternion r = Quaternion.LookRotation(new Vector3(hit.point.x, crossSection.transform.position.y, hit.point.z) - crossSection.transform.position);
				if (!lastUsed) crossSectionRotationOffset = crossSection.transform.rotation * Quaternion.Inverse(r);
				
				crossSection.transform.rotation = r * crossSectionRotationOffset;
				
				if (main.references.optimizations.realtimeCrossSectioning) {
					if (crossSection.shaderMode != CrossSection.ShaderMode.Enabled) crossSection.Enable();
					crossSection.UpdateClippingPlane();
				}
			}
		}
		
		lastUsed = isUsed;
		
		if (!transformToolsUsed && lastTransformToolsUsed) crossSection.DisableDouble();
		lastTransformToolsUsed = transformToolsUsed;

		Vector3 screenRoot = mainCamera.WorldToScreenPoint(crossSection.transform.position);
		Vector3 screenDirection = (mainCamera.WorldToScreenPoint(crossSection.transform.position + crossSection.transform.forward) - screenRoot).normalized;
		
		scissors.transform.localPosition = screenRoot;
		
		dottedLine.localPosition = screenRoot + screenDirection * dottedLineOffset;
		dottedLine.localRotation = Quaternion.LookRotation(screenDirection);
		
		rotate.transform.localPosition = screenRoot + screenDirection * rotateOffset;
		
		cam.transform.localPosition = scissors.transform.localPosition + new Vector3(0, 50 * sizeF, 0);
	}
	
	private float rotateOffset {
		get {
			if (size == 0) return 195;
			return 250;
		}
	}
	
	private float dottedLineOffset {
		get {
			if (size == 0) return 25;
			return 50;
		}
	}
	
	private float sizeF { get { return size + 1; }}
}
