using UnityEngine;
using System.Collections;

[ExecuteInEditMode]
public abstract class UIAutoScaleBase : UIShowHide {

	public Vector2 defaultScale;
	public Vector2 defaultScreen;
	
	public abstract void OnUpdateScale();
	public abstract void OnUpdate();
	
	void Awake () {
		if (!isValid) return;
		OnUpdateScale();
	}
	
	void Update () {
		if (!isValid) return;
		if (!Application.isPlaying) OnUpdateScale();
		else OnUpdate();
	}
	
	private bool isValid {
		get {
			if (defaultScale.x <= 0 || defaultScale.y <= 0) return false;
			if (defaultScreen.x <= 0 || defaultScreen.y <= 0) return false;
			return true;
		}
	}
	
	public float widthAspectMlp {
		get {
			return Mathf.Clamp(1 + ((aspectDefaultScreen - aspectScreen) * 2), 1, Mathf.Infinity);
		}
	}
	
	public float aspectDefaultScreen {
		get {
			return (float)defaultScreen.y / (float)defaultScreen.x;
		}
	}
	
	public float aspectScreen {
		get {
			return (float)Screen.height / (float)Screen.width;
		}
	}
	
	public float currentScaleF {
		get {
			return transform.localScale.y / defaultScale.y;
		}
	}
	
	public float screenHeightAspect {
		get {
			return (float)Screen.height / (float)defaultScreen.y;
		}
	}
	
	public float screenHeightOffset {
		get {
			return Screen.height - defaultScreen.y;
		}
	}
}
