using UnityEngine;
using System.Collections;

[ExecuteInEditMode]
public class UIAutoScale : UIAutoScaleBase {
	
	public UITexture uiTexture;
	public bool updateTransform, updateColor;
	public float yOffset = -0.5f;
	
	public override void OnUpdateScale() {
		transform.localPosition = currentLocalPosition + new Vector3(0, defaultScale.y * yOffset, transform.localPosition.z);
		transform.localScale = new Vector3(defaultScale.x * widthAspectMlp, defaultScale.y * widthAspectMlp, 1);
	}
	
	public override void OnUpdate() {
		if (updateTransform) OnUpdateScale();
		if (updateColor) uiTexture.color = currentColor;
	}
}
