using UnityEngine;
using System.Collections;

public class Translator : MonoBehaviour {

	[System.Serializable]
	public enum Language {
		Estonian,
		English,
		Russian
	}
	
	[System.Serializable]
	public enum Alphabet {
		Latin,
		Cyrillic
	}
	
	[System.Serializable]
	public class Text {
		
		[System.Serializable]
		public class Translation {
			public Language language;
			public string text;
		}
		
		public string name;
		public Translation[] translations;
	}
	
	public Text[] texts;
	
	public string GetTranslation(string name, Language language) {
		foreach (Text text in texts) {
			if (text.name == name) {
				foreach (Text.Translation translation in text.translations) {
					if (translation.language == language) return translation.text;
				}
			}
		}
		return string.Empty;
	}
	
	public static Alphabet GetAlphabet(Language language) {
		switch(language) {
		case Language.Russian: return Alphabet.Cyrillic;
		default: return Alphabet.Latin;
		}
	}
}
