using UnityEngine;
using System.Collections;

public class QualityManager : MonoBehaviour {

	void Awake() {
		switch(Application.platform) {
		case RuntimePlatform.Android:
			//QualitySettings.SetQualityLevel(GetQualityLevelAndroid());
			return;
		case RuntimePlatform.IPhonePlayer:
			QualitySettings.SetQualityLevel(GetQualityLevelIOS());
			return;
		}
	}
	
	private int GetQualityLevelAndroid() {
		if (Screen.height < 640) return 1;
		return 2;
	}
	
	private int GetQualityLevelIOS() {
		if (Screen.height < 2000) return 1;
		return 2;
	}
}
