using UnityEngine;
using System.Collections;

public class Operator : MonoBehaviour {
	
	[System.Serializable]
	public enum CustomBuildTarget {
		Android,
		IOS,
		OSX,
		Windows,
		Windows64,
		Linux,
		WebPlayer,
		WebPlayerStreamed
	}
	
	[System.Serializable]
	public class LevelIdentifier {
		public string level;
		
		public int minScreenHeight;
			
		public bool MatchHeight(int height) {
			return minScreenHeight <= height;
		}
	}
	
	public LevelIdentifier GetLevelIdentifier() {
		LevelIdentifier r = levelIdentifiers[0];
		
		foreach (LevelIdentifier l in levelIdentifiers) {
			if (l.MatchHeight(Screen.height)) {
				if (l.minScreenHeight > r.minScreenHeight) {
					r = l;
				}
			}
		}
		
		return r;
	}
	
	[System.Serializable]
	public class BuildTargetOptions {
		public CustomBuildTarget buildTarget;
		public string locationPathName = "";
		
		public string fullLocationPath {
			get {
				return locationPathName + fileExt;
			}
		}
		
		private string fileExt {
			get {
				switch(buildTarget) {
				case Operator.CustomBuildTarget.Android: return ".apk";
				case Operator.CustomBuildTarget.IOS: return ".ipa";
				case Operator.CustomBuildTarget.Windows: return ".exe";
				case Operator.CustomBuildTarget.Windows64: return ".exe";
				default: return string.Empty;
				}
			}
		}	
	}
	
	public bool use = false;
	public BuildTargetOptions[] buildTargetOptions;
	public LevelIdentifier[] levelIdentifiers;
	
	public string[] levels {
		get {
			string[] _levels = new string[levelIdentifiers.Length + 1];
			_levels[0] = "Assets/Operator.unity";
			for (int i = 1; i < levelIdentifiers.Length + 1; i++) {
				_levels[i] = "Assets/" + levelIdentifiers[i - 1].level + ".unity";
			}
			return _levels;
		}
	}

	void Start() {
		if (use) {
			Application.LoadLevel(GetLevelIdentifier().level);
			Destroy(gameObject);
		}
	}
}
