using UnityEngine;
using System.Collections;

public class GeoMeshManager : MonoBehaviour {
	
	[System.Serializable]
	public class MeshContainer {
		
		[System.Serializable]
		public enum Type {
			LowPoly,
			HighPoly
		}
		
		public Type type;
		public Mesh[] meshes;
	}
	
	public Transform[] geoMeshes;
	public MeshContainer[] meshContainers;
	
	public void SetResolution(MeshContainer.Type type) {
		foreach (MeshContainer c in meshContainers) {
			if (c.type == type) {
				for (int i = 0; i < geoMeshes.Length; i++) {
					MeshFilter filter = (MeshFilter)geoMeshes[i].GetComponent<MeshFilter>();
					filter.mesh = c.meshes[i];
				}
			}
		}
	}
	
	private float minGap = 0.0004f, maxGap = 0.001f;
	
	public void SetScale(float scale) {
		transform.localScale = new Vector3(1, scale, 1);
		
		float gap = Mathf.Clamp(0.01f / scale, minGap, maxGap);
		
		for (int i = 0; i < geoMeshes.Length; i++) {
			geoMeshes[i].transform.localPosition = new Vector3(0, -gap * i, 0);
		}
	}
}
