using UnityEngine;
using UnityEditor;
using System.Collections;

[CustomEditor(typeof(UIInterface))]
public class UIInterfaceInspector : Editor {
	
	UIInterface script;
	Translator.Language language;
	
	public override void OnInspectorGUI () {
		script = target as UIInterface;
		
		EditorGUILayout.LabelField("Debug Languages");
		language = (Translator.Language)EditorGUILayout.EnumPopup("Language", language);
		
		if (GUILayout.Button("Set Language")) {
			Translator translator = (Translator)GameObject.FindObjectOfType(typeof(Translator));
			script.SetLanguage(translator, language);
			
			UIPanel[] panels = (UIPanel[])script.transform.GetComponentsInChildren<UIPanel>();
			foreach (UIPanel panel in panels) panel.Refresh();
		}
		
		EditorGUILayout.Space();
		
		
		EditorGUIUtility.LookLikeInspector();
		
		DrawDefaultInspector();
		
		if (GUI.changed) EditorUtility.SetDirty(script);
	}
	
}
