using UnityEngine;
using UnityEditor;
using System.Collections;

public class SceneManager : EditorWindow {
	
    [MenuItem ("GeoApp/SceneManager")]
    static void Init () {
		EditorWindow.GetWindow(typeof(SceneManager));
    }
	
	void OnGUI () {
		EditorGUILayout.Space();
		
		if (GUILayout.Button("Create Scenes")) CreateScenes();
    }
	
	public static void CreateScenes() {
		if (!EditorApplication.currentScene.Contains("Main")) EditorApplication.OpenScene("Assets/Main.unity");
		
		CreateScene(Main.DeviceName.Mobile);
		CreateScene(Main.DeviceName.MobileRetina);
		CreateScene(Main.DeviceName.Standalone);
		CreateScene(Main.DeviceName.Tablet);
		CreateScene(Main.DeviceName.TabletRetina);
		CreateScene(Main.DeviceName.Web);
	}
	
	private static void CreateScene(Main.DeviceName deviceName) {
		if (!EditorApplication.currentScene.Contains("Main")) {
			Debug.LogError("Failed to create scenes, we are not in the Main scene");
			return;
		}
		
		string sceneName = deviceName.ToString();
		EditorApplication.SaveScene("Assets/" + sceneName + ".unity", false);
		Deployment.SwitchDeployment(deviceName, true);
		EditorApplication.SaveScene();
		EditorApplication.OpenScene("Assets/Main.unity");
	}
}