using UnityEngine;
using UnityEditor;
using System.Collections;

public class Builder : EditorWindow {
	
    [MenuItem ("GeoApp/Builder")]
    static void Init () {
		EditorWindow.GetWindow(typeof(Builder));
    }
	
	private bool Android, IOS, OSX, Windows, Windows64, Linux, WebPlayer, WebPlayerStreamed, updateScenes;
	
    void OnGUI () {
		Android = false; //EditorGUILayout.Toggle("Android", Android);
		IOS = false; //EditorGUILayout.Toggle("IOS", IOS);
		OSX = EditorGUILayout.Toggle("OSX", OSX);
		Windows = EditorGUILayout.Toggle("Windows", Windows);
		Windows64 = EditorGUILayout.Toggle("Windows64", Windows64);
		Linux = EditorGUILayout.Toggle("Linux", Linux);
		WebPlayer = EditorGUILayout.Toggle("WebPlayer", WebPlayer);
		WebPlayerStreamed = EditorGUILayout.Toggle("WebPlayerStreamed", WebPlayerStreamed);
		
		EditorGUILayout.Space();
		
		EditorGUILayout.LabelField("Make sure you are not in the Game view!");
		updateScenes = EditorGUILayout.Toggle("Update Scenes", updateScenes);
		
		if (GUILayout.Button("Build")) {			
			if (EditorApplication.SaveCurrentSceneIfUserWantsTo()) {
				if (updateScenes) SceneManager.CreateScenes();
				EditorApplication.OpenScene("Assets/Operator.unity");
				
				if (Android) Build (BuildTarget.Android);
				if (IOS) Build (BuildTarget.iPhone);
				if (OSX) Build (BuildTarget.StandaloneOSXIntel);
				if (Windows) Build (BuildTarget.StandaloneWindows);
				if (Windows64) Build (BuildTarget.StandaloneWindows64);
				if (Linux) Build (BuildTarget.StandaloneLinux);
				if (WebPlayer) Build (BuildTarget.WebPlayer);
				if (WebPlayerStreamed) Build (BuildTarget.WebPlayerStreamed);
			}
		}
    }
	
	private void Build(BuildTarget _buildTarget) {
		Operator o = GetOperator(_buildTarget);
		Operator.BuildTargetOptions b = GetBuildTargetOptions(o, _buildTarget);
			
		Operator[] operators = (Operator[])GameObject.FindSceneObjectsOfType(typeof(Operator));
		foreach (Operator otherOperator in operators) otherOperator.use = otherOperator == o;
			
		BuildPipeline.BuildPlayer(o.levels, b.fullLocationPath, _buildTarget, BuildOptions.None);
	}
	
	private Operator GetOperator(BuildTarget b) {
		Operator[] operators = (Operator[])GameObject.FindSceneObjectsOfType(typeof(Operator));
		
		foreach (Operator o in operators) {
			if (GetBuildTargetOptions(o, b) != null) return o;
		}
		
		Debug.LogError("Operator with buildTarget " + b.ToString() + " was not found");
		return null;
	}
	
	private Operator.BuildTargetOptions GetBuildTargetOptions(Operator o, BuildTarget _buildTarget) {
		foreach (Operator.BuildTargetOptions b in o.buildTargetOptions) if (ConvertBuildTarget(b.buildTarget) == _buildTarget) return b;
		return null;
	}
	
	private BuildTarget ConvertBuildTarget(Operator.CustomBuildTarget c) {
		switch(c) {
		case Operator.CustomBuildTarget.Android: return BuildTarget.Android;
		case Operator.CustomBuildTarget.IOS: return BuildTarget.iPhone;
		case Operator.CustomBuildTarget.OSX: return BuildTarget.StandaloneOSXIntel;
		case Operator.CustomBuildTarget.Windows: return BuildTarget.StandaloneWindows;
		case Operator.CustomBuildTarget.Windows64: return BuildTarget.StandaloneWindows64;
		case Operator.CustomBuildTarget.Linux: return BuildTarget.StandaloneLinux;
		case Operator.CustomBuildTarget.WebPlayer: return BuildTarget.WebPlayer;
		case Operator.CustomBuildTarget.WebPlayerStreamed: return BuildTarget.WebPlayerStreamed;
		default: return BuildTarget.WebPlayer;
		}
	}
	
	private void DebugLevels(BuildTarget _buildTarget) {
		Operator o = GetOperator(_buildTarget);
		string[] levels = o.levels;
		for (int i = 0; i < levels.Length; i++) {
			Debug.Log(levels[i]);
		}
	}
}