Shader "CrossSection/CrossSectionBumpedSpecularDisabled" {
    Properties {
      _MainTex ("Texture", 2D) = "white" {}
      _BumpMap ("Bumpmap", 2D) = "bump" {}
      _MainColor ("Main Color", Color) = (1, 1, 1, 1)
    }
    
    SubShader {    
      Tags { "RenderType" = "Opaque" }
     
       CGPROGRAM
      #pragma surface surf BlinnPhong
      
      struct Input {
        float2 uv_MainTex;
        float2 uv_BumpMap;
      };
      
      sampler2D _MainTex;
      sampler2D _BumpMap;
      float4 _MainColor;
      
      void surf (Input IN, inout SurfaceOutput o) {
        o.Normal = UnpackNormal (tex2D (_BumpMap, IN.uv_BumpMap));
		o.Albedo = tex2D(_MainTex, IN.uv_MainTex) * _MainColor.rgb;
      }
      ENDCG
    } 
    Fallback "Specular"
  }